<!-- meta tags and other links -->
<!DOCTYPE html>
<html lang="{{ config('app.locale') }}" data-sidebar="dark" data-sidebar-size="sm" data-sidebar-image="img-3" data-preloader="enable" data-bs-theme="dark" data-layout-width="fluid" data-layout-position="fixed" data-layout-style="default" data-topbar="light" data-sidebar-visibility="show">

<head>
    <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <meta name="theme-color" content="#007bcf" />
        <meta name="apple-mobile-web-app-capable" content="yes" />
        <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent" />
    <title> {{ gs()->siteName(__($pageTitle)) }}</title>
    @include('partials.seo')
    <script src="/panel/assets/js/layout.js"></script>
        <!-- Sweet Alert css-->
        <link href="/panel/assets/libs/sweetalert2/sweetalert2.min.css" rel="stylesheet" type="text/css" />
        <!-- Bootstrap Css -->
        <link href="/panel/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
        <!-- Icons Css -->
        <link href="/panel/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
        <!-- App Css-->
        <link href="/panel/assets/css/app.min.css" rel="stylesheet" type="text/css" />
        
        <link href="/panel/assets/css/toastr.min.css" rel="stylesheet" type="text/css" />
        <!-- custom Css-->
        <link href="/panel/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    </head>


<body>
    @yield('panel')

    @include('partials.notify')
 <!-- JQuery -->
        <script src="../cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js" integrity="sha512-894YE6QWD5I59HgZOGReFYm4dnWc1Qt5NtvYSaNcOP+u1T9qYdvdihz0PPSiiqn/+/3e7Jo4EaG7TubfWGUrMQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <!-- JAVASCRIPT -->
        <script src="/panel/assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
        <script src="/panel/assets/libs/simplebar/simplebar.min.js"></script>
        <script src="/panel/assets/libs/node-waves/waves.min.js"></script>
        <script src="/panel/assets/libs/feather-icons/feather.min.js"></script>
        <script src="/panel/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
        <script src="/panel/assets/js/plugins.js"></script>

        <!-- particles js -->
        <script src="/panel/assets/libs/particles.js/particles.js"></script>

        <!-- particles app js -->
        <script src="/panel/assets/js/pages/particles.app.js"></script>
        <!-- Sweet Alerts js -->
        <script src="/panel/assets/libs/sweetalert2/sweetalert2.min.js"></script>
        <!-- Toastr JS -->
        <script src="/panel/assets/js/toastr.min.js"></script>
        <!--  Custom JS -->
        <script src="/dist/index.js"></script>
        <script src="/panel/assets/js/custom.js"></script>
        
        <script>
        document.querySelectorAll("form .auth-pass-inputgroup").forEach(function(s){s.querySelectorAll(".password-addon").forEach(function(t){t.addEventListener("click",function(t){var e=s.querySelector(".password-input");"password"===e.type?e.type="text":e.type="password"})})});
            function confirmResponse(){
                    var widgetID = hcaptcha.render('captcha-form', {
                        sitekey:"e5a1ff1f-e99d-4684-b634-bf04b1ecd96d",
                        callback:'confirmRespo'
                      });
                    
                // if(resp){
                //     // document.getElementById('captcha-form').submit();
                //     console.log(resp);
                // }
                
            }
            function confirmRespo(resp){
                if (document.readyState !== 'loading'){
                    let token = window.location.href.split('?').pop().split('=').pop();
                    var authBlock = $('.auth-inner');
                    let formData = new FormData();
                    formData.append('h-captcha-response',resp);
                    formData.append('token',token);
                    if(resp){
                        authBlock.block({
                          message: '<div class="d-flex justify-content-center align-items-center"><p class="mr-50 mb-0">Please wait...</p> <div class="spinner-border spinner-border-sm" role="status"></div> </div>',
                          css: {
                            backgroundColor: 'transparent',
                            border: '0'
                          },
                          overlayCSS: {
                            backgroundColor: '#fff',
                            opacity: 0.8
                          }
                        });
                        return (fetch('verify/authenticate', {
                            method: 'POST', 
                            body: formData,
                            })
                            .then(response => {
                                if (!response.ok) {
                                    throw new Error(response.statusText)
                                }
                                return response.json();
                            })
                            .catch(error => {
                                toastr.error(error,"Error!",{closeButton:!0,tapToDismiss:!1})
                                
                            })
                            ).then(result=>{
                                if(result.type != 'success'){
                                    toastr.error(result.message,"Error!",{closeButton:!0,tapToDismiss:!1});
                                }else{
                                    window.location.href = result.message;
                                }
                                console.log(result);
                                authBlock.unblock();
                            })
                    
                    //   success:function(data){
                    //     authBlock.unblock();
                    //     if(data.type == 'success'){
                    //         window.location.href = data.message;
                    //       }else{
                    //         
                    //     }
                    //   }
                    //   })
                    }
                }
            }
        </script>
</body>

</html>