@extends($activeTemplate . 'layouts.dash')
@section('panel')
    @php
        $authContent = getContent('authentication.content', true);
    @endphp
    
    <!-- Account Section -->
    <div class="auth-page-wrapper pt-5">
            <!-- auth page bg -->
            <div class="auth-one-bg-position " id="auth-particles">
                <div class="bg-overlay"></div>
            </div>
            <!-- auth page content -->
            <div class="auth-page-content">
              <div class="container">
                  <div class="row">
                      <div class="col-lg-12">
                          <div class="text-center mt-sm-5 mb-4 text-white-50">
                              <div>
                                  <a href="/" class="d-inline-block auth-logo">
                                      <img src="{{ siteLogo() }}" alt="" height="40" />
                                  </a>
                              </div>
                              <!-- <p class="mt-3 fs-15 fw-medium">Premium Admin & Dashboard Template</p> -->
                          </div>
                      </div>
                  </div>
                  <!-- end row -->

                
                                <div class="row justify-content-center">
                    <div class="col-md-8 col-lg-6 col-xl-5">
                        <div class="card mt-4">

                            <div class="card-body p-4">
                                <div class="text-center mt-2">
                                    <h5 class="text-['0080db']">Welcome Back !</h5>
                                    <p class="text-muted">Sign in to continue to {{gs()->site_name}}.</p>
                                </div>
                                <div class="p-2 mt-4">
                                    <div class="alert bg-light text-center">
                                        <small class="fs-6 text-white">Please make sure you are visiting</small>
                                        <p class="text-white mb-0"><span class="text-success"><i class="ri-lock-2-fill align-bottom"></i> https://</span>{{ request()->getHost() }}</p>
                                    </div>
                                    
                            <form method="POST" id="login-form" action="{{ route('user.login') }}" class="verify-gcaptcha">
                                @csrf
                                <div class="mb-3">
                                            <label for="email" class="form-label">Email</label>
                                            <input type="email" name="username" class="form-control" id="email" placeholder="Enter email" required>
                                        </div>

                                        <div class="mb-3">
                                            <div class="float-end">
                                                <a href="{{ route('user.password.request') }}" class="text-muted">Forgot password?</a>
                                            </div>
                                            <label class="form-label" for="password-input">Password</label>
                                            <div class="position-relative auth-pass-inputgroup mb-3">
                                                <input type="password" class="form-control pe-5" placeholder="Enter password" name="password" id="password-input" required>
                                                <button class="btn btn-link position-absolute end-0 top-0 text-decoration-none text-muted password-addon" type="button" id="password-addon"><i class="ri-eye-fill align-middle"></i></button>
                                            </div>
                                        </div>

                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="" id="auth-remember-check" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
                                            <label class="form-check-label" for="auth-remember-check">Remember me</label>
                                        </div>

                                        <div class="mt-4">
                                            <button id="loginBtn" class="btn text-uppercase w-100" style="background-color:#0080db" type="submit">Sign In</button>
                                        </div>

                                    </form>
                                </div>
                            </div>
                            <!-- end card body -->
                        </div>
                        <!-- end card -->

                        <div class="mt-4 text-center">
                            <p class="mb-0 text-white-50">Don't have an account? <a href="{{ route('user.register') }}" class="fw-semibold text-decoration-underline" style="color:#0080db"> Sign Up </a> </p>
                        </div>

                    </div>
                </div>
                <!-- end row -->
                            
            

<script>
    document.getElementById("password-addon")&&document.getElementById("password-addon").addEventListener("click",function(){var e=document.getElementById("password-input");"password"===e.type?e.type="text":e.type="password"});
</script>                      <!-- footer -->
                      </div>
                    <!-- end container -->
                </div>
                <!-- end auth page content -->
            <footer class="footer mb-3">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="text-center">
                                <p class="mb-0 text-white-50">
                                    &copy;
                                    {{ date('Y') }}
                                    {{gs()->site_name}}. Standard Cryptocurrency Bitcoin Wallet
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </footer>
            <!-- end Footer -->
        </div>
    <!-- Account Section -->
@endsection
