@extends($activeTemplate . 'layouts.master')
@section('content')
<div class="appHeader text-light ico1" style="display: none;">
            <div class="left">
                                    <a href="javascript:void()" onclick="history.back();" class="headerButton">
                        <ion-icon name="chevron-back-outline" role="img" class="icon md hydrated" aria-label="chevron back outline"></ion-icon>
                    </a>
                               
                
            </div>
            <div class="pageTitle">
                <img src="{{ siteLogo() }}" width="150" alt="">
            </div>
            <div class="right">
                <a href="{{route('user.alerts')}}" class="headerButton">
                    <ion-icon class="icon md hydrated" name="notifications" role="img" aria-label="notifications"></ion-icon>
                </a>
            </div>
        </div>
<div id="appCapsule" class="container">
            <div>
                <div id="ContentPlaceHolder1_UpdatePanel1">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h5 class="card-title">Manage Transfer Pin and Limits</h5>
                                </div>
                                <div class="card-body">
                                    <div id="ContentPlaceHolder1_dpterm_modal" class="container">
                                        <div class="text-danger" style="text-align: center; font-weight: bold; margin-bottom: 10pt;"><span id="ContentPlaceHolder1_Lblmsg">Input boxes marked with asterisk are required</span></div>
                                        <br>
                                        <form class="profile-form" data-type="pin"action="{{ route('user.update.pass') }}" method="post">
                        @csrf
                                            <div class="row">
                                                <div class="form-group basic mb-3 col-md-6">
                                                    <label class="pin1">Enter Transfer Pin *</label>
    
                                                    <input name="password" type="password" maxlength="4" id="pin1" title="Digits Only" pattern="\d*" data-valid="numb" class="form-control form-control-lg" autocomplete="new-password" required="">
                                                </div>
                                                <div class="form-group basic mb-3 col-md-6">
                                                    <label class="pin2">Repeat Pin *</label>
    
                                                    <input name="password_confirmation" type="password" maxlength="4" id="pin2" title="Digits Only" pattern="\d*" data-valid="numb" class="form-control form-control-lg" autocomplete="new-password" required="">
                                                </div>
                                        </div>
    
                                            <div class="mb-3">
                                                
                                                <button type="submit" class="btn btn-primary mr-2 profile-btn" style="border-radius:0;">Save Changes </button>
                                                <input id="cancel" class="btn btn-light" type="submit" onclick="location.href='{{route('user.profile.setting')}}';return false" value="Cancel" style="border-radius:0; ">
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!------------MODAL----------------->
                </div>

                <script>
                    var isValid = true;
                    function ValidateAll() {
                        if (isValid) {
                            var password = $("input[id*=pin]").val(),
                                rPassword = $("[id*=pin2]").val();
                            if (password !== rPassword) {
                                toastr.error('Transfer pin mismatch',"",{positionClass:"toast-top-right","onclick": null, showEasing: "swing",timeOut: "5000"})
                                isValid = false;
                            } else {
                                if (!password.length == 4) {
                                    alertify.alert("Alert", "Transfer Pin Length must be 4");
                                    isValid = false;
                                    
                                }
                            }
                        }else{
                            
                        }
                        return isValid;
                    }
                </script>
                
                
                <script src="/static/__Numeric.js"></script>
            </div>
        </div>
@endsection