@extends($activeTemplate . 'layouts.master')
@section('content')
@if(session('show_transfer_modal'))
     @include('partials.swal2')
@endif
@php
    $walletNames = [
        'btc_wallet'      => 'Bitcoin',
        'eth_wallet'      => 'Ethereum',
        'usdt_wallet'     => 'USDT (ERC20)',
        'usdt_trc_wallet' => 'USDT (TRC20)',
        'tron_wallet'     => 'TRON',
        'bnb_wallet'      => 'BNB',
        'xrp_wallet'      => 'XRP',
        'xlm_wallet'      => 'XLM',
    ];
@endphp

<div class="appHeader text-light ico1" style="display: none;">
            <div class="left">
                                    <a href="javascript:void()" onclick="history.back();" class="headerButton">
                        <ion-icon name="chevron-back-outline" role="img" class="icon md hydrated" aria-label="chevron back outline"></ion-icon>
                    </a>
                               
                
            </div>
            <div class="pageTitle">
                <img src="{{ siteLogo() }}" width="150" alt="">
            </div>
            <div class="right">
                <a href="{{route('user.alerts')}}" class="headerButton">
                    <ion-icon class="icon md hydrated" name="notifications" role="img" aria-label="notifications"></ion-icon>
                </a>
            </div>
        </div>
        
        <div id="appCapsule" class="container">
    <div>
        <div id="ContentPlaceHolder1_UpdatePanel1">

            <div id="ContentPlaceHolder1__Form" class="row">
                <div id="ContentPlaceHolder1_Sect_1">
                    <div class="col-md-12 grid-margin stretch-card mb-3">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title">Swap Crypto</h5>
                            </div>
                            <div class="card-body">
                                                                <form class="" action="{{ route('user.swap.submit') }}" method="post">
                        @csrf
                                    <div class="form-group basic row">
                                        <div class="col"></div>
                                    </div>
                                    <div id="ContentPlaceHolder1_UpdatePanel2">
                                        <div class="form-group basic row">
                                            <div class="col">
                                                <div>
                                                    <label class="impo">Convert From:</label>
                                                    <div class="input-group mxf">
                                                        <div class="input-group-text">
                                                            <img class="from_logo" src="/assets/images/coin/77655.svg" width="20" alt="">
                                                        </div>

                                                        <select name="from_wallet" id="coin-from" class="form-control form-control-lg">
                                                                                                                        <option selected="selected" value="btc_wallet" data-symbol="BTC" data-name="Bitcoin" data-value="{{ gs()->btc_rate }}" data-balance="{{$user->btc_wallet}}" data-src="/assets/images/coin/77655.svg">Bitcoin (BTC)</option>
                                                                
                                                                                                                        <option value="eth_wallet" data-symbol="ETH" data-name="Ethereum" data-value="{{ gs()->eth_rate }}" data-balance="{{$user->eth_wallet}}" data-src="/assets/images/coin/29869.svg">Ethereum (ETH)</option>
                                                                
                                                                                                                        <option value="usdt_wallet" data-symbol="USDT" data-name="USDT (ERC 20)" data-value="1" data-balance="{{$user->usdt_wallet}}" data-src="/assets/images/coin/38081.svg">USDT (ERC 20) (USDT)</option>
                                                                
                                                                                                                        <option value="usdt_trc_wallet" data-symbol="USDT" data-name="USDT (TRC20)" data-value="1" data-balance="{{$user->usdt_trc_wallet}}" data-src="/assets/images/coin/45373.svg">USDT (TRC20) (USDT)</option>
                                                                
                                                                                                                        <option value="tron_wallet" data-symbol="TRX" data-name="TRON" data-value="{{ gs()->tron_rate }}" data-balance="{{$user->tron_wallet}}" data-src="/assets/images/coin/34272.svg">TRON (TRX)</option>
                                                                
                                                                                                                        <option value="bnb_wallet" data-symbol="BNB" data-name="BNB Smart Chain" data-value="{{ gs()->bnb_rate }}" data-balance="{{$user->bnb_wallet}}" data-src="/assets/images/coin/89776.png">BNB Smart Chain (BNB)</option>
                                                                                
                                        <option value="xrp_wallet" data-symbol="XRP" data-name="Ripple" data-value="{{ gs()->xrp_rate }}" data-balance="{{$user->xrp_wallet}}" data-src="/assets/images/coin/52.png">Ripple (XRP)</option> 
                                        
                                        <option value="xlm_wallet" data-symbol="XLM" data-name="Stellar Lumens" data-value="{{ gs()->xlm_rate }}" data-balance="{{$user->xlm_wallet}}" data-src="/assets/images/coin/512.png">Stellar Lumens (XLM)</option> 
                                                                                                                    </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div style="font-size: 11.4pt; font-weight: 600; text-align: right; color: var(--AppColor);">
                                            <span>Balance:&nbsp;</span><span id="assetBal">{{$user->btc_wallet}}</span>
                                            <span style="display: none;"></span>
                                        </div>
                                        </div>

                                        
                                    </div>

                                    <div id="ContentPlaceHolder1_UpdatePanel3">
                                        <div class="form-group basic row">
                                            <div class="col">
                                                <div class="mb-3">
                                                    <label class="impo">Convert To:</label>
                                                    <div class="input-group mxf">
                                                        <div class="input-group-text">
                                                            <img class="to_logo" src="/assets/images/coin/29869.svg" width="20" alt="">
                                                        </div>

                                                        <select name="to_wallet" id="coin-to" class="form-control form-control-lg">
                                                                                                                        <option value="btc_wallet" data-symbol="BTC" data-name="Bitcoin" data-value="{{ gs()->btc_rate }}" data-balance="{{$user->btc_wallet}}" data-src="/assets/images/coin/77655.svg">Bitcoin (BTC)</option>
                                                            
                                                                                                                        <option selected="selected" value="eth_wallet" data-symbol="ETH" data-name="Ethereum" data-value="{{ gs()->eth_rate }}" data-balance="{{$user->eth_wallet}}" data-src="/assets/images/coin/29869.svg">Ethereum (ETH)</option>
                                                            
                                                                                                                        <option value="usdt_wallet" data-symbol="USDT" data-name="USDT (ERC 20)" data-value="1" data-balance="{{$user->usdt_wallet}}" data-src="/assets/images/coin/38081.svg">USDT (ERC 20) (USDT)</option>
                                                            
                                                                                                                        <option value="usdt_trc_wallet" data-symbol="USDT" data-name="USDT (TRC20)" data-value="1" data-balance="{{$user->usdt_trc_wallet}}" data-src="/assets/images/coin/45373.svg">USDT (TRC20) (USDT)</option>
                                                            
                                                                                                                        <option value="tron_wallet" data-symbol="TRX" data-name="TRON" data-value="{{ gs()->tron_rate }}" data-balance="{{$user->tron_wallet}}" data-src="/assets/images/coin/34272.svg">TRON (TRX)</option>
                                                            
                                                                                                                        <option value="bnb_wallet" data-symbol="BNB" data-name="BNB Smart Chain" data-value="{{ gs()->bnb_rate }}" data-balance="{{$user->bnb_wallet}}" data-src="/assets/images/coin/89776.png">BNB Smart Chain (BNB)</option>
                                                            
                                        <option value="xrp_wallet" data-symbol="XRP" data-name="Ripple" data-value="{{ gs()->xrp_rate }}" data-balance="{{$user->xrp_wallet}}" data-src="/assets/images/coin/52.png">Ripple (XRP)</option> 
                                        
                                        <option value="xlm_wallet" data-symbol="XLM" data-name="Stellar Lumens" data-value="{{ gs()->xlm_rate }}" data-balance="{{$user->xlm_wallet}}" data-src="/assets/images/coin/512.png">Stellar Lumens (XLM)</option>                                                                             </select>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group basic row">
                                        <div class="col">
                                            <label class="amount">Amount($):</label>
                                            <input name="amount" type="number" id="swap_amount" class="form-control form-control-lg mb-3" data-valid="decimal">
                                        </div>
                                    </div>

                                    <div class="form-group basic row">
                                        <div class="col">
                                            <label class="pin">Transaction pin</label>
                                            <input name="pin" type="password" autocomplete="off" maxlength="4" class="form-control form-control-lg" required="" title="Digits Only" pattern="\d*" data-valid="numb">
                                        </div>
                                    </div>
                                    <div class="form-group basic row">
                                        <div class="col-6">
                                            <p class="text-primary">Receive</p>
                                        </div>
                                        <div class="col-6">
                                            <p class="text-end text-primary swap_receive">0</p>
                                        </div>
                                    </div>
                                    <div class="form-group basic row">
                                        <p class="ref_price"></p>
                                    </div>
                                    
                                    <div class="form-group basic row text-end">
                                        <button type="submit" class="btn btn-primary confirm_purchase_btn" style="border-radius:0">Confirm Swap</button>
                                    </div>
                                </form>
                                                            </div>
                        </div>
                        <div id="ContentPlaceHolder1_History_Part1" class="card mb-3">
                    <!--COLUMNS--->
                    
                </div>
                    </div>
                </div>
            </div>
            <div id="ContentPlaceHolder1__Form" class="row">
                <div id="ContentPlaceHolder1_Sect_1">
                    <div class="col-md-12 grid-margin stretch-card mb-3">
                        <div class="card">
                        <div class="card-header">
                            <h5 class="card-title">History</h5>
                        </div>
                        <div class="card-body ">
                        <div class="table-responsive">
                            <table class="table  table-borderless tbxx">
                                <thead>
                                    <tr>
                                        <th>TRX</th>
                                        <th>Crypto</th>
                                        <th>Amount</th>
                                        <th>Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($transactions as $trx)
                                     <tr>
                                         <td>
                                         {{ $trx->trx }}
                                     </td>
                                      <td>
                                         {{ $walletNames[$trx->wallet_type] ?? ucfirst(str_replace('_', ' ', $trx->wallet_type)) }}
                                     </td>
                                     <td>
                                         {{ $trx->trx_type }} {{ getAmount($trx->amount,8) }}
                                     </td>
                                     <td>
                                         {{ showDateTime($trx->created_at) }}
                                     </td>
                                     </tr>
                                    
                                    @empty <tr id="ContentPlaceHolder1_Repeater1_empty_search">
                                        <td class="table__section table__section--grow" colspan="999" style="text-align: center; color: #721c24; font-weight: 600; background: #d7b3b7; border: 1px solid #e2b0b5; font-variant: small-caps;">
                                            - No Transactions Found -
                                        </td>
                                    </tr>
                                    @endforelse
                                                                </tbody>
                                
                            </table>
                        </div>
                    </div>
                    </div>
                    </div>
                </div>
        </div>
        <script src="/static/__Numeric.js"></script>
        <script src="/static/js/settings.js"></script>
    </div>
</div>
</div>



@endsection