@php
    $currencyCode = $record->method_currency ?? $record->currency;

    $currencyNames = [
        'BTC' => 'Bitcoin',
        'ETH' => 'Ethereum',
        'USDT' => 'Tether (USDT)',
        'BNB' => 'Binance Coin',
        'TRX' => 'Tron',
    ];
    $currencyName = $currencyNames[strtoupper($currencyCode)] ?? $currencyCode;
     $type = null;
    $walletAddress = null;

    if (is_iterable($record->withdraw_information)) {
        foreach ($record->withdraw_information as $field) {
            if (isset($field->name)) {
                if ($field->name === 'Type') {
                    $type = $field->value ?? null;
                }
                if ($field->name === 'Wallet Address') {
                    $walletAddress = $field->value ?? null;
                }
            }
        }
    }
@endphp
<ul class="listview mtg flush transparent simple-listview no-space mt-3">
    <li>
        <strong>Status</strong>
        @if ($mode === 'deposit' && $record->status == Status::PAYMENT_SUCCESS)
        <span class="text-success">Received</span>
        @elseif ($mode === 'deposit' && $record->status == 2)
        <span class="text-warning">Pending</span>
        @elseif ($mode === 'withdrawal' && $record->status == Status::PAYMENT_SUCCESS)
        <span class="text-success">Sent</span>
         @elseif ($mode === 'withdrawal' && $record->status == Status::PAYMENT_PENDING)
         <span class="text-warning">Processing</span>
         @else
         <span class="text-danger">Failed</span>
         @endif
    </li>
    @if ($record->status == Status::PAYMENT_SUCCESS)
    <li>
                                    <strong>Confirmations</strong>
                                    <span data-tld="Confirmation">10/10</span>
                                </li>
                                @elseif ($record->status == Status::PAYMENT_PENDING)
                                <li>
                                    <strong>Confirmations</strong>
                                    <span data-tld="Confirmation">0/10</span>
                                </li>@endif
    <li>
        <strong>Amount</strong>
        <div class="text-end">
            <h3 class="m-0">{{getAmount($record->final_amount,8) }} {{ $record->method_currency ?? $record->currency }}</h3>
            <small>{{showAmount($record->amount) }}</small>
        </div>
    </li>
    <li>
        <strong>Token</strong>
        <span>{{ $currencyName }}</span>
    </li>
    @if($type)
    <li>
        <strong>Wallet Address</strong>
        <span>{{ $walletAddress }}</span>
    </li>
    <li>
        <strong>Transaction Type</strong>
        <span>{{ $type }}</span>
    </li>
    @endif

    <li>
        <strong>Date</strong>
        <span>{{ showDateTime($record->created_at) }}</span>
    </li>
  
</ul>
