<?php $__env->startSection('panel'); ?>


<div class="row justify-content-center">
    <?php if(request()->routeIs('admin.deposit.list') || request()->routeIs('admin.deposit.method')): ?>
        <div class="col-12">
            <?php echo $__env->make('admin.deposit.widget', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    <?php endif; ?>

    <div class="col-md-12">
        <div class="card">
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two">
                        <thead>
                        <tr>
                            <th><?php echo app('translator')->get('Gateway | Transaction'); ?></th>
                            <th><?php echo app('translator')->get('Initiated'); ?></th>
                            <th><?php echo app('translator')->get('User'); ?></th>
                            <th><?php echo app('translator')->get('Amount'); ?></th>
                            <th><?php echo app('translator')->get('Conversion'); ?></th>
                            <th><?php echo app('translator')->get('Status'); ?></th>
                            <th><?php echo app('translator')->get('Action'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php
                                $details = $deposit->detail ? json_encode($deposit->detail) : null;
                            ?>
                            <tr>
                                <td>
                                    <span class="fw-bold">
                                        <a href="<?php echo e(appendQuery('method',$deposit->method_code < 5000 ? @$deposit->gateway->alias : $deposit->method_code)); ?>">
                                            <?php if($deposit->method_code < 5000): ?>
                                                <?php echo e(__(@$deposit->gateway->name)); ?>

                                            <?php else: ?>
                                                <?php echo app('translator')->get('Google Pay'); ?>
                                            <?php endif; ?>
                                        </a>
                                    </span>
                                     <br>
                                     <small> <?php echo e($deposit->trx); ?> </small>
                                </td>

                                <td>
                                    <?php echo e(showDateTime($deposit->created_at)); ?><br><?php echo e(diffForHumans($deposit->created_at)); ?>

                                </td>
                                <td>
                                    <span class="fw-bold"><?php echo e($deposit->user->fullname); ?></span>
                                    <br>
                                    <span class="small">
                                    <a href="<?php echo e(appendQuery('search',@$deposit->user->username)); ?>"><span>@</span><?php echo e($deposit->user->username); ?></a>
                                    </span>
                                </td>
                                <td>
                                   <?php echo e(showAmount($deposit->amount)); ?> + <span class="text--danger" title="<?php echo app('translator')->get('charge'); ?>"><?php echo e(showAmount($deposit->charge)); ?> </span>
                                    <br>
                                    <strong title="<?php echo app('translator')->get('Amount with charge'); ?>">
                                    <?php echo e(showAmount($deposit->amount+$deposit->charge)); ?>

                                    </strong>
                                </td>
                                <td>
                                    <?php echo e(showAmount(1)); ?> =  <?php echo e(showAmount($deposit->rate,currencyFormat:false)); ?> <?php echo e(__($deposit->method_currency)); ?>

                                    <br>
                                    <strong><?php echo e(showAmount($deposit->final_amount,currencyFormat:false)); ?> <?php echo e(__($deposit->method_currency)); ?></strong>
                                </td>
                                <td>
                                    <?php echo $deposit->statusBadge ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('admin.deposit.details', $deposit->id)); ?>"
                                       class="btn btn-sm btn-outline--primary ms-1">
                                        <i class="la la-desktop"></i> <?php echo app('translator')->get('Details'); ?>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table><!-- table end -->
                </div>
            </div>
            <?php if($deposits->hasPages()): ?>
            <div class="card-footer py-4">
                <?php echo paginateLinks($deposits) ?>
            </div>
            <?php endif; ?>
        </div><!-- card end -->
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <?php if (isset($component)) { $__componentOriginale48b4598ffc2f41a085f001458a956d1 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale48b4598ffc2f41a085f001458a956d1 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.search-form','data' => ['dateSearch' => 'yes','placeholder' => 'Username / TRX']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('search-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['dateSearch' => 'yes','placeholder' => 'Username / TRX']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $attributes = $__attributesOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__attributesOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $component = $__componentOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__componentOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/syqhlpzd/web3worldchainsecurity.org/core/resources/views/admin/deposit/log.blade.php ENDPATH**/ ?>